<?php

declare(strict_types=1);

namespace Drupal\tool\Plugin\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\TypedDataInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetBase;
use Drupal\tool\Attribute\TypedDataSchemaWidget;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetTrait;

/**
 * Plugin implementation for handling multiple values (lists).
 */
#[TypedDataSchemaWidget(
  id: 'list',
  label: new TranslatableMarkup('List'),
  description: new TranslatableMarkup('Widget for handling multiple values in list data types.'),
  data_types: ['list'],
// Higher priority for list items.
  weight: -10,
)]
final class ListWidget extends TypedDataSchemaWidgetBase {

  use TypedDataSchemaWidgetTrait;

  /**
   * {@inheritdoc}
   */
  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array {
    $form = [];
    return $form;
  }

  /**
   * Submit handler for "Add more" button.
   */
  public function addMore(array &$form, SubformStateInterface $form_state): void {
    // Trigger form rebuild to add another item.
    $form_state->setRebuild();
  }

  /**
   * Submit handler for "Remove" button.
   */
  public function removeItem(array &$form, SubformStateInterface $form_state): void {
    $triggering_element = $form_state->getTriggeringElement();
    $delta = $triggering_element['#delta'];

    // Get current values and remove the specified item.
    $values = $form_state->getValue('items', []);
    unset($values[$delta]);

    // Re-index the array.
    $values = array_values($values);

    // Update form state.
    $form_state->setValue('items', $values);
    $form_state->setRebuild();
  }

  /**
   * AJAX callback for add/remove operations.
   */
  public function ajaxCallback(array &$form, SubformStateInterface $form_state): array {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function extractFormValues(TypedDataInterface $data, FormStateInterface $form_state): void {
  }

}
