<?php

declare(strict_types=1);

namespace Drupal\tool\Plugin\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\TypedDataInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetBase;
use Drupal\tool\Attribute\TypedDataSchemaWidget;

/**
 * Plugin implementation of the data_type_form_widget.
 */
#[TypedDataSchemaWidget(
  id: 'number',
  label: new TranslatableMarkup('Number'),
  description: new TranslatableMarkup('Number input for number data types.'),
  data_types: ['integer', 'decimal', 'float'],
)]
final class NumberWidget extends TypedDataSchemaWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array {
    $form['value'] = [
      '#type' => 'number',
      '#title' => $data->getDataDefinition()->getLabel(),
      '#default_value' => $data->getValue(),
      '#description' => $data->getDataDefinition()->getDescription(),
      '#required' => $data->getDataDefinition()->isRequired(),
      '#description_display' => 'after',
      '#disabled' => $data->getDataDefinition()->isReadOnly(),
    ];
    // Set the step for floating point and decimal numbers.
    switch ($data->getDataDefinition()->getDataType()) {
      case 'decimal':
        $form['value']['#step'] = 0.1;
        break;

      case 'float':
        $form['value']['#step'] = 'any';
        break;
    }
    return $form;
  }

}
