<?php

declare(strict_types=1);

namespace Drupal\tool\TypedData\SchemaWidget;

use Drupal\Component\Utility\SortArray;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\TypedData\DataDefinitionInterface;
use Drupal\tool\Attribute\TypedDataSchemaWidget;

/**
 * TypedDataSchemaWidget plugin manager.
 */
final class TypedDataSchemaWidgetPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/tool/TypedData/SchemaWidget', $namespaces, $module_handler, TypedDataSchemaWidgetInterface::class, TypedDataSchemaWidget::class);
    $this->alterInfo('data_type_form_widget_info');
    $this->setCacheBackend($cache_backend, 'data_type_form_widget_plugins');
  }

  /**
   * Gets the appropriate schema widget definition for a given data definition.
   */
  public function getDefinitionFromDataType(DataDefinitionInterface $data_definition): ?array {
    $definitions = $this->getDefinitions();
    uasort($definitions, [SortArray::class, 'sortByWeightElement']);
    foreach ($definitions as $definition) {
      if ($definition['class']::isApplicable($data_definition)) {
        return $definition;
      }
    }
    return $this->getDefinition('undefined');
  }

}
