<?php

namespace Drupal\tool\TypedData\SchemaWidget;

use Drupal\Core\TypedData\DataDefinitionInterface;
use Drupal\Core\TypedData\TypedDataTrait;

/**
 * Trait for typed data schema widgets.
 */
trait TypedDataSchemaWidgetTrait {
  use TypedDataTrait;

  /**
   * The schema widget plugin manager.
   *
   * @var \Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetPluginManager
   */
  protected TypedDataSchemaWidgetPluginManager $schemaWidgetManager;

  /**
   * The schema widget plugin instances.
   *
   * @var array
   */
  protected array $schemaWidgetInstances = [];

  /**
   * Returns the schema widget manager.
   */
  protected function getSchemaWidgetManager() {
    if (empty($this->schemaWidgetManager)) {
      $this->schemaWidgetManager = \Drupal::service('plugin.manager.typed_data_schema_widget');
    }
    return $this->schemaWidgetManager;
  }

  /**
   * Gets the schema widget instance for a given data definition.
   */
  public function getSchemaWidgetInstance(DataDefinitionInterface $data_definition, string $name) {
    if (!isset($this->schemaWidgetInstances[$name])) {
      $schema_widget_definition = $this->getSchemaWidgetManager()->getDefinitionFromDataType($data_definition);
      $this->schemaWidgetInstances[$name] = $this->getSchemaWidgetManager()->createInstance($schema_widget_definition['id']);
    }
    return $this->schemaWidgetInstances[$name];
  }

}
