<?php

namespace Drupal\tool\TypedData;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\TypedData\ListDataDefinitionInterface;

/**
 * Defines a context definition for input data types.
 */
class InputDefinition extends ContextDefinition implements InputDefinitionInterface {
  use InputDefinitionTrait;

  /**
   * Constructs a new context definition object.
   *
   * @param string $data_type
   *   The required data type.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string|null $label
   *   The label of this context definition for the UI.
   * @param bool $required
   *   Whether the context definition is required.
   * @param bool $multiple
   *   Whether the context definition is multivalue.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string|null $description
   *   The description of this context definition for the UI.
   * @param mixed $default_value
   *   The default value of this definition.
   * @param array<string, mixed> $constraints
   *   An array of constraints keyed by the constraint name and a value of an
   *   array constraint options or a NULL.
   * @param bool $locked
   *   Whether the input is locked, meaning it cannot be changed by context or
   *   configuration.
   */
  public function __construct($data_type = 'any', $label = NULL, $required = TRUE, $multiple = FALSE, $description = NULL, $default_value = NULL, ?array $constraints = [], bool $locked = FALSE) {
    parent::__construct($data_type, $label, $required, $multiple, $description, $default_value, $constraints);
    $this->isLocked = $locked;
  }

  /**
   * {@inheritdoc}
   */
  public function getDataDefinition() {
    $definition = parent::getDataDefinition();
    // @todo Fix upstream.
    if ($this->isMultiple() && $definition instanceof ListDataDefinitionInterface) {
      $item_definition = $definition->getItemDefinition();
      foreach ($this->getConstraints() as $name => $options) {
        $item_definition->addConstraint($name, $options);
      }
    }
    return $definition;
  }

}
