<?php

namespace Drupal\tool\TypedData;

trait InputDefinitionTrait {

  /**
   * Determines whether the value is locked.
   *
   * @var bool
   *   Whether a data value is locked.
   */
  protected $isLocked = FALSE;

  /**
   * The form alter values or callback.
   *
   * @var array
   */
  protected $formAlter;

  /**
   * The array of config schema definitions.
   *
   * @var array
   */
  protected $configSchemaOverride;
  /**
   * {@inheritdoc}
   */
  public function isLocked(): bool {
    return $this->isLocked;
  }

  /**
   * {@inheritdoc}
   */
  public function setLocked($locked = TRUE): self {
    $this->isLocked = $locked;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormAlter(): array {
    return $this->formAlter;
  }

  /**
   * {@inheritdoc}
   */
  public function setFormAlter(array $form_alter): self {
    $this->formAlter = $form_alter;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigSchemaOverride(): array {
    return $this->configSchemaOverride;
  }

  /**
   * {@inheritdoc}
   */
  public function setConfigSchemaOverride(array $config_schema_override): self {
    $this->configSchemaOverride = $config_schema_override;
    return $this;
  }
}
