<?php

namespace Drupal\top10_google_news\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'GoogleNews' Block.
 *
 * @Block(
 *   id = "top_10_google_news_Content_block",
 *   admin_label = @Translation("Top 10 Google News"),
 *   category = @Translation("Google News Content Block"),
 * )
 */
class Top10GoogleNewsContentBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $client = \Drupal::httpClient();
    $class = 'google-new-content-block';
    $config = \Drupal::config('top10_google_news.adminsettings');
    $key = $config->get('google_api_key');
    $version = $config->get('api_version');
    $newsCategory = $config->get('content_news_category');
    $language = $config->get('content_language');
    $country = $config->get('content_country');

    //logic for calling google api bases on diffrent parameters.
    if ($newsCategory != 'default' & $language != 'default') {
      $str = "https://newsapi.org/" . $version . "/top-headlines?country=" . $country . "&category=" . $newsCategory . "&language=" . $language . "&apiKey=" . $key;
    }
    elseif ($newsCategory != 'default' & $language == 'default') {
      $str = "https://newsapi.org/" . $version . "/top-headlines?country=" . $country . "&category=" . $newsCategory . "&apiKey=" . $key;
    }
    elseif ($newsCategory == 'default' & $language != 'default') {
      $str = "https://newsapi.org/" . $version . "/top-headlines?country=" . $country . "&language=" . $language . "&apiKey=" . $key;
    }
    else {
      $str = "https://newsapi.org/" . $version . "/top-headlines?country=" . $country . "&apiKey=" . $key;
    }
    $request = $client->get($str);
    $result = json_decode($request->getBody(), TRUE);
    $articles = array_slice($result['articles'], 0, 10);
    return [
      '#theme' => "google_news",
      '#data' => $articles,
      '#class' => $class,
      '#attached' => [
        'library' => [
          'top10_google_news/top10_google_news',
        ],
      ],
    ];
  }

}
