# Tour Extras

This module provides additional tip plugins as submodules.

## Requirements

This module requires the following modules:

- Tour (contrib)

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Submodules

### Tour Extras WYSIWYG

**Module Name:** `tour_extras_wysiwyg`  
**Tip Plugin ID:** `text_formatted`

Provides a formatted text tip plugin that extends the standard text tip with WYSIWYG editing capabilities.

#### Features

- Rich text editing with CKEditor integration
- Support for all available text formats
- Token replacement support
- Filter processing for secure content display
- Maintains all standard tour tip functionality (positioning, selectors, etc.)

#### Usage

1. Enable the Tour Extras WYSIWYG module
2. Create or edit a tour
3. Add a new tip and select "Formatted Text" as the tip type
4. Use the WYSIWYG editor to create rich content with formatting, links, lists, etc.
5. Select the appropriate text format for your content
6. Configure positioning and other standard tip options

### Tour Extras URL Step

**Module Name:** `tour_extras_url_step`  
**Tip Plugin ID:** `url_step`

Provides a URL step tip plugin that removes the last step of a tour and hooks into the preceding step's "Next" button action, to redirect to a specified url.

Together with the "?tours" and "?tips" query parameters, this feature can be used for multi page tours.

#### Important Usage Notes

⚠️ **WARNING**: This plugin should always be used as the **last step** in a tour.

#### Usage

1. Enable the Tour Extras URL Step module
2. Create or edit a tour
3. Add a new tip and select "URL Step" as the tip type
4. Configure the URL step (this should be set as the final step):
   - **URL**: Enter a relative or absolute URL (e.g., `/admin/content`, `https://example.com/`)
   - **Cancel Button Label**: Set the text for the redirect button (defaults to "Next"). Supports tokens.
