/**
 * @file
 * JavaScript behaviors for tour_extras_url_step module.
 */

(function (Drupal, $) {
  /**
   * Handles URL redirection when the next button is clicked on the last tour step.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.tourExtrasUrlStepRedirect = {
    attach(context, settings) {
      // Use once to ensure this only runs once per context
      $(document).on('drupalTourStarted', () => {
        // Get all tour steps and register URL step handlers
        const { steps } = Drupal.tour.get();
        steps.forEach((step) => {
          // Check if the step has a URL step URL:
          if (settings._tour_internal) {
            const stepConfigWithUrl = settings._tour_internal.find((config) => {
              return config.id === step.id && config.url_step_url;
            });

            // There is no step config with a URL step URL,
            // continue to the next step:
            if (!stepConfigWithUrl) {
              return;
            }

            // If the step has a URL step URL, set the button action to
            // redirect to the URL.
            // The second button is the next button, register the
            // action to redirect to the URL:
            step.options.buttons[1].action = () => {
              window.location.href = stepConfigWithUrl.url_step_url;
            };
          }
        });
      });
    },
  };
})(Drupal, jQuery);
