<?php

namespace Drupal\tour_extras_wysiwyg\Plugin\tour\tip;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\tour\Attribute\Tip;
use Drupal\tour\TipPluginBase;

/**
 * Displays formatted text as a tip with WYSIWYG support.
 */
#[Tip(
  id: 'text_formatted',
  title: new TranslatableMarkup('Formatted Text'),
)]
class TipPluginTextFormatted extends TipPluginBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
      'body' => [
        'value' => '',
        'format' => filter_default_format(),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getBody(): array {
    $text = $this->get('body')['value'];
    $format = $this->get('body')['format'];

    return [
      '#type' => 'processed_text',
      '#text' => $text,
      '#format' => $format,
      '#attributes' => [
        'class' => [
          'tour-tip-body',
          'tour-tip-body--formatted-text',
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildConfigurationForm($form, $form_state);

    // Use text_format field instead of textarea for WYSIWYG support.
    $form['body'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Body'),
      '#required' => TRUE,
      '#default_value' => $this->get('body')['value'],
      '#format' => $this->get('body')['format'],
      '#description' => $this->t('The tip body content.'),
    ];

    return $form;
  }

}
