# Drupal.org Project Page Description

**Copy the content below when creating the project on drupal.org**

---

## Short Description (for search/listings)

Comprehensive email audit logging for Symfony Mailer with SMTP transcripts, delivery tracking, filtering, and CSV/JSON export.

---

## Full Description (for project page body)

### Overview

Trace Mail Log provides complete visibility into your Drupal site's outgoing emails. It integrates with [Symfony Mailer](https://www.drupal.org/project/symfony_mailer) to capture every email event, storing the full SMTP conversation so you can verify delivery and troubleshoot issues.

**Unlike simple mail catchers**, this module doesn't just intercept emails—it logs them as they flow through your actual mail transport, capturing real SMTP server responses.

### Key Features

**Complete Email Tracking**
- Automatic logging of all outgoing emails
- Full SMTP transcript capture with server responses
- Email lifecycle tracking: queued → sending → sent/failed
- Records sender, recipients (To/Cc/Bcc), subject, and response codes

**Dashboard & Reporting**
- At-a-glance statistics: emails sent today, this week, total
- Failure monitoring with quick access to recent errors
- Filterable log list (by status, event type, recipient)
- Sortable columns with AJAX-powered navigation
- Export to CSV or JSON for external analysis

**Enterprise Ready**
- Configurable retention with automatic purging
- Secure storage of transcript files in private filesystem
- Granular permissions for viewing vs administering
- Privacy options: disable body logging if needed

### Use Cases

- **Email Delivery Verification**: Confirm emails are accepted by SMTP servers
- **Troubleshooting**: Debug delivery failures with full SMTP transcripts
- **Compliance & Audit**: Maintain records of all outgoing communications
- **Development**: Test email workflows with detailed logging

### Requirements

- Drupal 10 or 11
- [Symfony Mailer](https://www.drupal.org/project/symfony_mailer) module

### Quick Start

```bash
composer require drupal/trace_mail_log
drush en trace_mail_log
```

Then visit **Admin > Configuration > System > Mail Log** to view your email logs.

### Screenshots

*(Add screenshots of: dashboard, log list, detail view with SMTP transcript)*

### Related Modules

- [Symfony Mailer](https://www.drupal.org/project/symfony_mailer) - Required dependency
- [Maillog](https://www.drupal.org/project/maillog) - Alternative for older mail systems (obsolete)
- [Mail Safety](https://www.drupal.org/project/mail_safety) - Catches/redirects emails (different purpose)

### Support

- Issue queue: Use the issue queue for bug reports and feature requests
- Documentation: See README.md in the module

---

## Project Settings

| Field | Value |
|-------|-------|
| Name | Trace Mail Log |
| Machine name | trace_mail_log |
| Module categories | Mail |
| Maintenance status | Actively maintained |
| Development status | Under active development |
| Security advisory coverage | Apply when ready |

---

## Composer Namespace

The module uses `drupal/trace_mail_log` as the Composer package name.
