# Trace Mail Log

Comprehensive email audit logging for Symfony Mailer with transport transcripts,
delivery tracking, filtering, and CSV/JSON export.

## Table of Contents

- [Description](#description)
- [Features](#features)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Permissions](#permissions)
- [Troubleshooting](#troubleshooting)
- [Maintainers](#maintainers)

## Description

Trace Mail Log provides complete visibility into your Drupal site's email
operations. Unlike simple mail catchers, this module logs emails as they flow
through the Symfony Mailer system, capturing the full transport conversation for
debugging delivery issues.

Key use cases:

- **Delivery verification**: Confirm emails are actually sent and accepted
- **Troubleshooting**: Debug delivery errors with full transaction transcripts
- **Audit trails**: Keep records of all outgoing emails for compliance
- **Development**: Test email functionality without a mail catcher

## Features

### Email Logging

- Captures all outgoing emails automatically via Symfony Mailer events
- Records sender, recipients (To, Cc, Bcc), subject, and timestamps
- Stores full transport transcripts with server responses
- Tracks email lifecycle: queued, sending, sent, failed, requeued
- Optionally logs email body content (HTML and plain text)

### Dashboard

- Overview statistics: total emails, sent today, sent this week
- Failure count with quick access to recent failures
- At-a-glance health check of your email system

### Log Management

- Filterable list by status, event type, and recipient
- Sortable columns (date, status, recipient, subject, response code)
- Configurable items per page with user override
- AJAX-powered filtering with bookmarkable URLs
- Detailed view with complete transport transcript

### Export

- Export to CSV or JSON format
- Export filtered results or entire log
- Suitable for external analysis or reporting

### Maintenance

- Configurable retention period with automatic purging
- Manual delete single entry or purge all
- Transcript files stored securely in private filesystem

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1 or higher
- [Symfony Mailer](https://www.drupal.org/project/symfony_mailer) module

## Installation

Install as you would normally install a contributed Drupal module. See
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-modules)
for further information.

### Using Composer (recommended)

```bash
composer require drupal/trace_mail_log
drush en trace_mail_log
```

### Manual Installation

1. Download the module from https://www.drupal.org/project/trace_mail_log
2. Extract to `modules/contrib/trace_mail_log`
3. Enable via Admin > Extend or `drush en trace_mail_log`

## Configuration

Navigate to **Administration > Configuration > System > Mail Log Settings**
(`/admin/config/system/mail-log/settings`).

### General Settings

| Setting | Description | Default |
|---------|-------------|---------|
| Enable mail logging | Turn logging on/off globally | Enabled |
| Retention period | Days to keep logs (0 = forever) | 30 days |
| Log file directory | Where transcript files are stored | `private://mail-logs` |
| Log email body | Include HTML/text body in transcripts | Disabled |
| Log attachments | Record attachment metadata | Disabled |

### Display Settings

| Setting | Description | Default |
|---------|-------------|---------|
| Date format (list) | Date format for the log list | Short |
| Date format (detail) | Date format for detail pages | Medium |
| Items per page | Default pagination size | 50 |

## Usage

### Viewing Logs

1. Navigate to **Administration > Configuration > System > Mail Log**
2. The dashboard shows statistics and recent failures
3. Click "List" tab to see all log entries
4. Use filters to narrow down results
5. Click a recipient email to view full details

### Filtering

- **Status**: pending, success, failed
- **Event Type**: queued, sending, sent, failed, requeued
- **Recipient**: Search by email address (partial match)

### Exporting

1. From the list view, click the "Export" dropdown
2. Choose format (CSV or JSON)
3. Choose scope:
   - "Export filtered" - current filter results
   - "Export all" - entire log database

### Understanding Event Types

| Event | Description |
|-------|-------------|
| queued | Email added to the mail queue |
| sending | Email transmission started |
| sent | Email accepted by mail server |
| failed | Delivery failed (see response for details) |
| requeued | Failed email scheduled for retry |

### Reading Transport Transcripts

The detail view shows the complete transport conversation. For SMTP transports,
this includes the full server dialog:

```
220 mail.example.com ESMTP
250-mail.example.com Hello
250-SIZE 52428800
250 DSN
250 OK
354 End data with <CR><LF>.<CR><LF>
250 2.0.0 Ok: queued as ABC123
```

For SMTP transports, response codes starting with:
- **2xx**: Success
- **4xx**: Temporary failure (may retry)
- **5xx**: Permanent failure

## Permissions

| Permission | Description |
|------------|-------------|
| View mail logs | Access dashboard and view log entries |
| Administer mail log settings | Configure settings, delete entries |

## Troubleshooting

### Emails not being logged

1. Verify the module is enabled
2. Check that "Enable mail logging" is on in settings
3. Ensure Symfony Mailer is the active mail system
4. Check Drupal logs for errors

### Transcript files not created

1. Verify the log directory exists and is writable
2. Recommended: use `private://mail-logs` for security
3. Check PHP error logs for permission issues

### High disk usage

1. Reduce retention period in settings
2. Disable "Log email body" if not needed
3. Run cron regularly to trigger automatic purging

### Export not working

1. Verify you have "View mail logs" permission
2. For large exports, increase PHP memory_limit
3. Check browser for download blocking

## Maintainers

- [fte](https://www.drupal.org/u/fte)

## Supporting Organizations

- [NSI](https://www.drupal.org/nsi-sa)

## License

This project is GPL-2.0-or-later licensed.
