<?php

declare(strict_types=1);

namespace Drupal\track_usage\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a file track usage attribute for plugin discovery.
 *
 * Plugin Namespace: Plugin/TrackUsage/Track.
 *
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Track extends Plugin {

  /**
   * Constructs a new attribute instance.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the track plugin.
   * @param string[] $fieldTypes
   *   (optional) The field types that this plugin is able to track.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly array $fieldTypes = [],
  ) {}

}
