<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of images embedded in WYSIWYG fields with CKEditor image plugin.
 */
#[Track(
  id: 'ckeditor_image',
  label: new TranslatableMarkup('CKEditor image'),
  fieldTypes: ['text', 'text_long', 'text_with_summary'],
)]
class CkEditorImage extends TextFieldBase {

  /**
   * {@inheritdoc}
   */
  protected function xpath(): string {
    return '//img[@data-entity-type="file" and @data-entity-uuid]';
  }

}
