<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\comment\Plugin\Field\FieldType\CommentItemInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Plugin\TrackUsage\TrackPluginBase;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of entities related in comment fields.
 */
#[Track(
  id: 'comment',
  label: new TranslatableMarkup('Comment'),
  fieldTypes: ['comment'],
)]
class Comment extends TrackPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getItemTargetEntities(FieldItemInterface $item): iterable {
    assert($item instanceof CommentItemInterface);

    $storage = $this->entityTypeManager->getStorage('comment');
    $host = $item->getEntity();

    $cids = $storage->getQuery()->accessCheck(FALSE)
      ->condition('entity_type', $host->getEntityTypeId())
      ->condition('entity_id', $host->id())
      ->condition('status', TRUE)
      ->execute();

    if ($cids) {
      foreach ($storage->loadMultiple($cids) as $comment) {
        yield $comment;
      }
    }
  }

}
