<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Plugin\TrackUsage\TrackPluginBase;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of entities related in dynamic_entity_reference fields.
 */
#[Track(
  id: 'dynamic_entity_reference',
  label: new TranslatableMarkup('Dynamic entity reference'),
  fieldTypes: ['dynamic_entity_reference'],
)]
class DynamicEntityReference extends TrackPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getItemTargetEntities(FieldItemInterface $item): iterable {
    // Only return a valid result if the target entity exists.
    if (!$item->isEmpty() && $entity = $this->entityTypeManager->getStorage($item->target_type)->load($item->target_id)) {
      yield $entity;
    }
  }

}
