<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of drupal-media tags in text fields.
 */
#[Track(
  id: 'media_embed',
  label: new TranslatableMarkup('Media embed'),
  fieldTypes: ['text', 'text_long', 'text_with_summary'],
)]
class MediaEmbed extends TextFieldBase {

  /**
   * {@inheritdoc}
   */
  protected function xpath(): string {
    return '//drupal-media[@data-entity-type="media" and @data-entity-uuid]';
  }

}
