<?php

declare(strict_types=1);

namespace Drupal\track_usage;

use Drupal\track_usage\Entity\TrackConfigInterface;
use Drupal\track_usage\Model\BulkUpdateMethod;

/**
 * Interface for bulk records all usages service.
 */
interface UpdaterInterface {

  /**
   * Updates all usages.
   *
   * @param \Drupal\track_usage\Model\BulkUpdateMethod $bulkUpdateMethod
   *   The bulk update method.
   * @param \Drupal\track_usage\Entity\TrackConfigInterface $config
   *   The track config.
   */
  public function update(BulkUpdateMethod $bulkUpdateMethod, TrackConfigInterface $config): void;

}
