<?php

declare(strict_types=1);

namespace Drupal\Tests\track_usage\Kernel\Track;

use Drupal\comment\Entity\Comment;
use Drupal\comment\Entity\CommentType;
use Drupal\comment\Tests\CommentTestTrait;
use Drupal\entity_test\Entity\EntityTest;

/**
 * Tests the 'comment' track plugin.
 *
 * @group track_usage
 */
class CommentTest extends TrackTestBase {

  use CommentTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'comment',
    'text',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('entity_test');
    $this->installEntitySchema('comment');
    $this->installSchema('comment', ['comment_entity_statistics']);
    $this->installConfig(['comment']);

    // Create a comment type.
    CommentType::create([
      'id' => 'comment',
      'label' => $this->randomString(),
      'target_entity_type_id' => 'entity_test',
    ])->save();
    $this->addDefaultCommentField('entity_test', 'entity_test');
  }

  /**
   * @covers \Drupal\track_usage\Plugin\TrackUsage\Track\Comment
   */
  public function testPlugin(): void {
    $entity = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
    ]);
    $entity->save();

    $ref1 = Comment::create([
      'entity_type' => 'entity_test',
      'name' => $this->randomString(),
      'subject' => $this->randomString(),
      'comment_body' => $this->randomString(),
      'entity_id' => $entity->id(),
      'comment_type' => 'comment',
      'field_name' => 'comment',
    ]);
    $ref1->setPublished()->save();

    $ref2 = Comment::create([
      'entity_type' => 'entity_test',
      'name' => $this->randomString(),
      'subject' => $this->randomString(),
      'comment_body' => $this->randomString(),
      'entity_id' => $entity->id(),
      'comment_type' => 'comment',
      'field_name' => 'comment',
      'pid' => $ref1->id(),
    ]);
    $ref2->setPublished()->save();

    // Unpublished comments are not followed.
    $ref3 = Comment::create([
      'entity_type' => 'entity_test',
      'name' => $this->randomString(),
      'subject' => $this->randomString(),
      'comment_body' => $this->randomString(),
      'entity_id' => $entity->id(),
      'comment_type' => 'comment',
      'field_name' => 'comment',
    ]);
    $ref3->save();

    $this->assertTargetEntities('comment', $entity, 'comment', [$ref1, $ref2]);
  }

}
