<?php

declare(strict_types=1);

namespace Drupal\Tests\track_usage\Kernel\Track;

use Drupal\entity_test\Entity\EntityTest;
use Drupal\Tests\field\Traits\EntityReferenceFieldCreationTrait;

/**
 * Tests the 'entity_reference' track plugin.
 *
 * @group track_usage
 */
class EntityReferenceTest extends TrackTestBase {

  use EntityReferenceFieldCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('entity_test');
    $this->createEntityReferenceField('entity_test', 'entity_test', 'ref', $this->randomString(), 'entity_test');
  }

  /**
   * @covers \Drupal\track_usage\Plugin\TrackUsage\Track\EntityReference
   */
  public function testPlugin(): void {
    $ref1 = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
    ]);
    $ref2 = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
    ]);

    $entity = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
      'ref' => [
        $ref1,
        $ref2,
        // Duplicates are not counted.
        $ref1,
      ],
    ]);
    $entity->save();

    $this->assertTargetEntities('entity_reference', $entity, 'ref', [$ref1, $ref2]);
  }

}
