# Track Usages

[![https://drupalcode.org/project/track_usage/badges/1.x/pipeline.svg](https://drupalcode.org/project/track_usage/badges/1.x/pipeline.svg)](https://drupalcode.org/project/track_usage)

## Description

The Track Usages module allows tracking and registering usages of a target
entity by a source entity. For instance, you can find and register which are
the file usages of a node entity. The tracker service will traverse entities
such as media or paragraph to get the node file usages regardless of the
nesting level.

### What about the Entity Usage module?

The popular [Entity Usage](https://www.drupal.org/project/entity_usage) module
is also tracking entity usages but is only recording one-step relationships.
This module is only interested in the relation between topmost entity (called
source entity) and the final destination (called target entity). Middle-level
entities (called traversable entities) relations are not recorded because they
are not relevant in the context of some applications. More or less this module
follows the ideas from
[#3060802](https://www.drupal.org/project/entity_usage/issues/3060802).

Main differences compared to Entity Usage:

- It only registers relations between _source_ (top-level) entities and _target_
  entities. _Traversable_ (middle-level) entities are traversed but not
  registered. This allows the database to scale, as with Entity Usage, very
  often the usage table becomes unmaintainable.
- The configuration is stored in config entities, meaning you can record usages
  for different scenarios. For instance, you may want to track the relation
  between nodes and their files, but for a different scope, you may want to
  track record the relation between node and taxonomy terms. For each scope, you
  will define a different configuration.
- This module doesn't offer any UI to end users.

## Configuration

After installing the module, navigate to `/admin/config/system/track-usage` and
press "New configuration". Fill and save the configuration form:
- Choose a human-readable and a machine name for this configuration.
- Select the plugins to be used to traverse entities. For instance, if you only
  select "Entity reference", the tracker will only follow the entity reference
  fields to search for target entities. Leave all unchecked to use all.
- Check "Track only the active entity revision" to track only the active
  revisions of source entities.
- Check "Record entity changes in real time" to update the usage records as the
  entities are inserted/updated/deleted. If unchecked, the usage records should
  be updated manually via UI or Drush.
- On the "Source entity types" you select the entity bundles to act as source
  entities. Entity type and bundle level granularity are both offered. This is a
  mandatory field, at least one bundle should be selected.
- On the "Traversable entity types" you select the entity bundles to act as
  traversable entities. Usually, these are entities such as media or paragraph.
- On the "Target entity types" you select the entity bundles to act as target
  entities. This is a mandatory field, at least one bundle should be selected.

On the `/admin/config/system/track-usage/settings` page you can configure how
the manual update of usage records should be done:
- Batch: The update is done as a batch process.
- Queue: The update is postponed to a queue process.
- Instant (not recommended): It's OK to use this on small amount of data and for
  testing purposes.

## Architecture

### Terminology

Source entity
: An entity for which we track and record target entity usage. For instance, a
node entity could act as _source_ entity.

Traversable entity
: An entity for which we don't create usage records but which is traversed to
reach other entities, which in turn can be target or also traversable entities.
A good example of _traversable_ entities is media and paragraph entities.

Target entities
: Entities whose usages are recorded based on a _source_ entity. A popular case
is the file entities.

### Services

#### The tracker

The tracker follows the _source_ entity fields, descends deep, by traversing the
_traversable_ entities, and collects usages of _target_ entities. The tracker is
using the _track plugins_ that know how to get an entity out of a field. The
tracker might return different results for the same entity, depending on the
used configuration.

#### The recorder

The recorder uses the tracker to gather usages and store them in the database.
Depending on the used configuration, the recorder is able to register usages in
real time when a _source_ entity gets inserted or updated.

#### The updater

The updater allows manual recreation or record usages either by UI or by
running a Drush command. The latter is the preferred method.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the recommended tool for contributing to the
module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering the tools to set up
and test the module.

### Install DDEV

* Install a Docker provider by following DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/)
  instructions for your Operating System.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/),
  use the documentation that best fits your OS.
* DDEV is used mostly via CLI commands. [Configure shell completion &
  autocomplete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/)
  according to your environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical
  step to be able to test and debug your module. Remember, the website runs
  inside Docker, so pay attention to these configurations:
  - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
  - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/)
    PhpStorm and VS Code for step debugging.
  - Profiling with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/),
    [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/)
    and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Checkout the module

Normally, you check out the code form an [issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):

```shell
git clone git@git.drupal.org:issue/track_usage-[issue number].git
cd track_usage-[issue number]
```

### Start DDEV

Inside the cloned project run:

```shell
ddev start
```

This command will fire up the Docker containers and add all configurations.

### Install dependencies

```shell
ddev poser
```

This will install the PHP dependencies. Note that this is a replacement for
Composer _install_ command that knows how to bundle together Drupal core and the
module. Read more about this command at
https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this
command at https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands.
Note that as soon as `vendor/autoload.php` has been generated, this command runs
automatically on every `ddev start`.

This command should also be run when adding new directories or files to the root
of the module.

```shell
ddev exec "cd web/core && yarn install"
```

Install Node dependencies. This is needed for the `ddev eslint` command.

### Install Drupal

```shell
ddev install
```

This will install Drupal and will enable the module.

### Changing the Drupal core version

* Create a file `.ddev/config.local.yaml`
* In the new config file, set the desired Drupal core version. E.g.,
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.4
  ```
* Run `ddev restart`

Refer to the original documentation: [Changing the Drupal core
version](https://github.com/ddev/ddev-drupal-contrib/blob/main/README.md#changing-the-drupal-core-version)

### Run tests

* `ddev phpunit`: run PHPUnit tests
* `ddev phpcs`: run PHP coding standards checks
* `ddev phpcbf`: fix coding standards findings
* `ddev phpstan`: run PHP static analysis
* `ddev eslint`: Run ESLint on Javascript and YAML files.
