<?php

declare(strict_types=1);

namespace Drupal\track_usage\Attribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attribute for entity role meta-information.
 */
#[\Attribute(\Attribute::TARGET_CLASS_CONSTANT)]
class EntityRoleMeta {

  public function __construct(
    public readonly TranslatableMarkup $title,
    public readonly TranslatableMarkup $description,
    public readonly bool $isTraversable = FALSE,
    public readonly bool $limitToFieldable = TRUE,
  ) {}

}
