<?php

declare(strict_types=1);

namespace Drupal\track_usage\Entity;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Entity list builder for 'track_usage_config' entities.
 */
class TrackConfigListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    return [
      'id' => $this->t('ID'),
      'label' => $this->t('Label'),
      'status' => $this->t('Status'),
      'realTimeRecording ' => $this->t('Realtime recording'),
    ] + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    \assert($entity instanceof TrackConfigInterface);

    return [
      'id' => $entity->id(),
      'label' => $entity->label(),
      'status' => $entity->status() ? $this->t('Enabled') : $this->t('Disabled'),
      'realTimeRecording' => $entity->useRealTimeRecording() ? $this->t('Yes') : $this->t('No'),
    ] + parent::buildRow($entity);
  }

}
