<?php

declare(strict_types=1);

namespace Drupal\track_usage;

use Drupal\Core\Entity\EntityInterface;

/**
 * Interface for the entity guesser service.
 */
interface EntityGuesserInterface {

  /**
   * Tries to guess an entity object out of a given URL.
   *
   * @param string $url
   *   The URL as string.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The entity, if one can be determined.
   */
  public function guessFromUrl(string $url): ?EntityInterface;

}
