<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of entities embedded into text fields using Entity Embed module.
 */
#[Track(
  id: 'entity_embed',
  label: new TranslatableMarkup('Entity embed'),
  fieldTypes: ['text', 'text_long', 'text_with_summary'],
)]
class EntityEmbed extends TextFieldBase {

  /**
   * {@inheritdoc}
   */
  protected function xpath(): string {
    return '//drupal-entity[@data-entity-type and @data-entity-uuid]';
  }

}
