<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Plugin\TrackUsage\TrackPluginBase;
use Drupal\track_usage\Attribute\Track;
use Drupal\track_usage\Trait\EntityUtilityTrait;

/**
 * Tracks usage of entities related in entity_reference fields.
 */
#[Track(
  id: 'entity_reference',
  label: new TranslatableMarkup('Entity reference'),
  fieldTypes: [
    'entity_reference',
    'entity_reference_revisions',
    'entity_reference_entity_modify',
    'file',
    'image',
    'webform',
  ],
)]
class EntityReference extends TrackPluginBase {

  use EntityUtilityTrait;

  /**
   * {@inheritdoc}
   */
  public function getItemTargetEntities(FieldItemInterface $item): iterable {
    if (!$entity = $item->entity) {
      return;
    }
    assert($entity instanceof EntityInterface);

    $targetType = $item->getFieldDefinition()->getSetting('target_type');
    $revisionId = method_exists($entity, 'getRevisionId') ? (int) $entity->getRevisionId() : 0;
    $entity = $this->loadEntity($targetType, $entity->id(), $revisionId);

    // Only return a valid result if the target entity exists.
    if ($entity) {
      yield $entity;
    }
  }

}
