<?php

declare(strict_types=1);

namespace Drupal\track_usage_test\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Url;
use Drupal\node\Entity\Node;

/**
 * Testing hooks.
 */
class TrackUsageTestHooks {

  /**
   * Implements hook_track_usage_entity_guess().
   */
  #[Hook('track_usage_entity_guess')]
  public function testHook(Url $url, ?string $langcode): ?EntityInterface {
    if ($url->toString() === '/abc') {
      return Node::load(1);
    }
    return NULL;
  }

}
