<?php

declare(strict_types=1);

namespace Drupal\Tests\track_usage\Kernel\Track;

use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\entity_test\Entity\EntityTest;
use Drupal\entity_test\Entity\EntityTestBundle;
use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;

/**
 * Tests the 'dynamic_entity_reference' track plugin.
 *
 * @group track_usage
 */
class DynamicEntityReferenceTest extends TrackTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'dynamic_entity_reference',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('entity_test');
    FieldStorageConfig::create([
      'entity_type' => 'entity_test',
      'field_name' => 'reference',
      'type' => 'dynamic_entity_reference',
      'cardinality' => FieldStorageDefinitionInterface::CARDINALITY_UNLIMITED,
    ])->save();
    FieldConfig::create([
      'entity_type' => 'entity_test',
      'bundle' => 'entity_test',
      'field_name' => 'reference',
      'label' => $this->randomString(),
    ])->save();
  }

  /**
   * @covers \Drupal\track_usage\Plugin\TrackUsage\Track\DynamicEntityReference
   */
  public function testPlugin(): void {
    $ref1 = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
    ]);
    $ref2 = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
    ]);

    $configEntity = EntityTestBundle::create([
      'id' => 'not_targeted',
      'label' => $this->randomString(),
    ]);
    $configEntity->save();

    $entity = EntityTest::create([
      'type' => 'entity_test',
      'name' => $this->randomString(),
      'reference' => [
        $ref1,
        $ref2,
        // Duplicates are not counted.
        $ref1,
        // Config entities are also accepted.
        $configEntity,
      ],
    ]);
    $entity->save();

    $this->assertTargetEntities('dynamic_entity_reference', $entity, 'reference', [$ref1, $ref2, $configEntity]);
  }

}
