<?php

/**
 * @file
 * Documentation related to Track Usage.
 */

declare(strict_types=1);

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;
use Drupal\node\Entity\Node;

/**
 * Add a custom entity guess.
 *
 * @param \Drupal\Core\Url $url
 *   The URL.
 * @param string|null $langcode
 *   The langcode or NULL, if it can't be determined from the path.
 *
 * @return \Drupal\Core\Entity\EntityInterface|null
 *   The entity or NULL.
 */
function hook_track_usage_entity_guess(Url $url, ?string $langcode): ?EntityInterface {
  if ($url->toString() === '/foo/bar') {
    return Node::load(123);
  }
  return NULL;
}
