<?php

declare(strict_types=1);

namespace Drupal\track_usage\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a block target attribute for plugin discovery.
 *
 * Plugin Namespace: Plugin/TrackUsage/BlockTarget.
 *
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class BlockTarget extends Plugin {

  /**
   * Constructs a new attribute instance.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the block target plugin.
   * @param list<non-empty-string> $blockPlugins
   *   List of block plugin base IDs where this plugin applies.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly array $blockPlugins,
  ) {}

}
