<?php

declare(strict_types=1);

namespace Drupal\track_usage\Model;

/**
 * How to update existing content.
 */
enum BulkUpdateMethod: string {

  // Use batch process.
  case Batch = 'batch';

  // Defer to a queue.
  case Queue = 'queue';

  // Instant update.
  case Instant = 'instant';

  /**
   * Returns the enum as an option list.
   *
   * @return array<\Drupal\track_usage\Model\BulkUpdateMethod, \Drupal\Component\Render\MarkupInterface>
   *   An option list.
   */
  public static function asOptions(): array {
    return [
      self::Batch->value => t('Batch'),
      self::Queue->value => t('Queue'),
      self::Instant->value => t('Instant (not recommended)'),
    ];
  }

}
