<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage;

use Drupal\Component\Plugin\PluginManagerInterface;

/**
 * Block target plugin manager interface.
 */
interface BlockTargetPluginManagerInterface extends PluginManagerInterface {

  /**
   * Returns a list of instances suitable for the passed block plugin base ID.
   *
   * @param string $blockPluginBaseId
   *   The block plugin base ID.
   *
   * @return array<non-empty-string, \Drupal\track_usage\Plugin\TrackUsage\BlockTargetPluginInterface>
   *   List of instances suitable for the passed block plugin base ID.
   */
  public function getApplicablePlugins(string $blockPluginBaseId): array;

}
