<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Field\FieldItemListInterface;

/**
 * Defines the interface for file track usage plugins.
 */
interface TrackPluginInterface extends PluginInspectionInterface {

  /**
   * Retrieves the target entities from a field item list.
   *
   * @param \Drupal\Core\Field\FieldItemListInterface $itemList
   *   The field item list instance.
   *
   * @return iterable<\Drupal\Core\Entity\FieldableEntityInterface>
   *   A list of target entities.
   */
  public function getTargetEntities(FieldItemListInterface $itemList): iterable;

}
