<?php

declare(strict_types=1);

namespace Drupal\track_usage;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\track_usage\Entity\TrackConfigInterface;

/**
 * Reads recorder usages.
 */
interface ReaderInterface {

  /**
   * Returns all recorded usages of a certain type for an entity.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $entity
   *   The entity. Could be a source entity (e.g., a node) or a traversable
   *   entity (e.g., a paragraph or media).
   * @param string $targetEntityTypeId
   *   The target entity type ID.
   * @param \Drupal\track_usage\Entity\TrackConfigInterface $config
   *   The track usage configuration to use.
   *
   * @return iterable<int|string>
   *   A list of target entity IDs.
   */
  public function getTargetsForEntity(FieldableEntityInterface $entity, string $targetEntityTypeId, TrackConfigInterface $config): iterable;

  /**
   * Returns a list of paths to a target entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $target
   *   The target entity.
   * @param \Drupal\track_usage\Entity\TrackConfigInterface $config
   *   The track usage configuration to use.
   *
   * @return list<list<array{string, string, string}>>
   *   A list of paths to the target entity. Each path is a list of triplets:
   *   0: The entity type ID.
   *   1: The entity ID.
   *   2: The revision ID.
   */
  public function getPathsToTarget(EntityInterface $target, TrackConfigInterface $config): array;

}
