<?php

declare(strict_types=1);

namespace Drupal\Tests\track_usage\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\track_usage\Traits\TestingDataTrait;

/**
 * Base class for track usage tests.
 *
 * @group track_usage
 */
abstract class TrackUsageTestBase extends KernelTestBase {

  use TestingDataTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_reference_revisions',
    'field',
    'file',
    'image',
    'language',
    'link',
    'media',
    'node',
    'paragraphs',
    'path_alias',
    'redirect',
    'system',
    'taxonomy',
    'text',
    'user',
    'filter',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('file');
    $this->installEntitySchema('node');
    $this->installEntitySchema('media');
    $this->installEntitySchema('path_alias');
    $this->installEntitySchema('paragraph');
    $this->installEntitySchema('redirect');
    $this->installSchema('file', ['file_usage']);
    $this->installSchema('node', ['node_access']);
    $this->installConfig(['language']);

    // Kernel tests don't run install hooks. Install the module explicitly.
    $this->container->get('module_installer')->install(['track_usage']);

    $this->createDataStructure();
  }

}
