<?php

declare(strict_types=1);

namespace Drupal\track_usage\Model;

use Drupal\Core\Entity\EntityInterface;

/**
 * Value object for entity usage.
 */
class Usage {

  /**
   * Constructs a new value object.
   *
   * @param \Drupal\Core\Entity\EntityInterface $targetEntity
   *   The target entity.
   * @param list<list<string>> $paths
   *   A list of paths to the target entity. Each path is a list entity
   *   identifiers. An empty list means the target entity is directly attached.
   *   Each identifier is the concatenation of entity type ID, entity ID and the
   *   revision ID, separated by colon. Example:
   *   @code
   *   [
   *     ['paragraph:2:5', 'media:6:7'],
   *     []
   *   ]
   *   @endcode
   */
  public function __construct(
    public readonly EntityInterface $targetEntity,
    public readonly array $paths,
  ) {}

  /**
   * Returns an array representation of the object, mostly for testing purposes.
   *
   * @return array<string, string|int, list<list<string>>>
   *   A tuple with the first element as the target entity ID and the second as
   *   the list of paths to target.
   */
  public function toArray(): array {
    return [$this->targetEntity->getEntityTypeId(), $this->targetEntity->id(), $this->paths];
  }

}
