<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\BlockTarget;

use Drupal\block_content\Plugin\Block\BlockContentBlock;
use Drupal\Core\Block\BlockPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\BlockTarget;
use Drupal\track_usage\Plugin\TrackUsage\BlockTargetPluginBase;

/**
 * Block Content block target plugin.
 */
#[BlockTarget(
  id: 'block_content',
  label: new TranslatableMarkup('Block Content'),
  blockPlugins: ['block_content'],
)]
class BlockContent extends BlockTargetPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getTargetEntities(BlockPluginInterface $block): iterable {
    assert($block instanceof BlockContentBlock);
    $uuid = $block->getDerivativeId();
    if ($block = $this->entityRepository->loadEntityByUuid('block_content', $uuid)) {
      yield $block;
    }
  }

}
