<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\BlockTarget;

use Drupal\Core\Block\BlockPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\BlockTarget;
use Drupal\track_usage\Plugin\TrackUsage\BlockTargetPluginBase;
use Drupal\entity_browser_block\Plugin\Block\EntityBrowserBlock as BlockEntityBrowserBlock;

/**
 * Plugin for Entity Browser Block.
 */
#[BlockTarget(
  id: 'entity_browser_block',
  label: new TranslatableMarkup('Entity Browser Block'),
  blockPlugins: ['entity_browser_block'],
)]
class EntityBrowserBlock extends BlockTargetPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getTargetEntities(BlockPluginInterface $block): iterable {
    assert($block instanceof BlockEntityBrowserBlock);
    $entitiesPerType = [];
    foreach ($block->getConfiguration()['entity_ids'] ?? [] as $key) {
      [$entityTypeId, $entityId] = explode(':', $key);
      $entitiesPerType[$entityTypeId][] = $entityId;
    }
    foreach ($entitiesPerType as $entityTypeId => $ids) {
      $ids = array_unique($ids);
      if ($this->entityTypeManager->hasDefinition($entityTypeId)) {
        foreach ($this->entityTypeManager->getStorage($entityTypeId)->loadMultiple($ids) as $entity) {
          yield $entity;
        }
      }
    }
  }

}
