<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Block\BlockPluginInterface;

/**
 * Defines the interface for block target plugins.
 *
 * Block target plugins know how to get referred entities out of a block plugin
 * instance. Each plugin is specialized in one or many block plugins. The block
 * target plugin should define the base IDs of block plugins they are covering.
 */
interface BlockTargetPluginInterface extends PluginInspectionInterface {

  /**
   * Retrieves the target entities from a block target list.
   *
   * @param \Drupal\Core\Block\BlockPluginInterface $block
   *   The block plugin instance.
   *
   * @return iterable<array-key, array<int|string, int|string>>
   *   Key is the entity type ID, value a list of entity IDs.
   */
  public function getTargetEntities(BlockPluginInterface $block): iterable;

}
