<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\track_usage\Attribute\BlockTarget;

/**
 * Plugin manager for block target plugins.
 */
class BlockTargetPluginManager extends DefaultPluginManager implements BlockTargetPluginManagerInterface {

  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cacheBackend,
    ModuleHandlerInterface $moduleHandler,
  ) {
    parent::__construct(
      'Plugin/TrackUsage/BlockTarget',
      $namespaces,
      $moduleHandler,
      BlockTargetPluginInterface::class,
      BlockTarget::class,
    );
    $this->alterInfo('file_usage_block_target_info');
    $this->setCacheBackend($cacheBackend, 'track_usage.block_target');
  }

  /**
   * {@inheritdoc}
   */
  public function getApplicablePlugins(string $blockPluginBaseId): array {
    return array_map(
      fn(array $definition): BlockTargetPluginInterface => $this->createInstance($definition['id']),
      array_filter(
        $this->getDefinitions(),
        fn(array $definition) => in_array($blockPluginBaseId, $definition['blockPlugins'], TRUE),
      )
    );
  }

}
