<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\Entity\EntityRepositoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\block_field\BlockFieldItemInterface;
use Drupal\track_usage\Plugin\TrackUsage\BlockTargetPluginManagerInterface;
use Drupal\track_usage\Plugin\TrackUsage\TrackPluginBase;
use Drupal\track_usage\Attribute\Track;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Tracks usage of entities related in block_field fields.
 */
#[Track(
  id: 'block_field',
  label: new TranslatableMarkup('Block field'),
  fieldTypes: ['block_field'],
 )]
class BlockField extends TrackPluginBase {

  public function __construct(
    array $configuration,
    string $plugin_id,
    mixed $plugin_definition,
    EntityRepositoryInterface $entityRepository,
    EntityTypeManagerInterface $entityTypeManager,
    protected readonly BlockTargetPluginManagerInterface $blockTargetPluginManager,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $entityRepository, $entityTypeManager);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity.repository'),
      $container->get('entity_type.manager'),
      $container->get(BlockTargetPluginManagerInterface::class),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getItemTargetEntities(FieldItemInterface $item): iterable {
    assert($item instanceof BlockFieldItemInterface);
    $blockInstance = $item->getBlock();
    foreach ($this->blockTargetPluginManager->getApplicablePlugins($blockInstance->getBaseId()) as $blockTarget) {
      foreach ($blockTarget->getTargetEntities($blockInstance) as $entity) {
        yield $entity;
      }
    }
  }

}
