<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage\Track;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\track_usage\Attribute\Track;

/**
 * Tracks usage of entities embedded into text fields using Linkit module.
 */
#[Track(
  id: 'linkit',
  label: new TranslatableMarkup('LinkIt'),
  fieldTypes: ['text', 'text_long', 'text_with_summary']
)]
class LinkIt extends TextFieldBase {

  /**
   * {@inheritdoc}
   */
  protected function xpath(): string {
    return '//a[@data-entity-type and @data-entity-uuid]';
  }

}
