<?php

declare(strict_types=1);

namespace Drupal\track_usage\Plugin\TrackUsage;

use Drupal\Component\Plugin\PluginManagerInterface;

/**
 * Track plugin manager interface.
 */
interface TrackPluginManagerInterface extends PluginManagerInterface {

  /**
   * Returns a list of plugin instances enabled in configuration.
   *
   * @param string $fieldType
   *   The field type to filter the list on.
   *
   * @return iterable<\Drupal\track_usage\Plugin\TrackUsage\TrackPluginInterface>
   *   Track plugins.
   */
  public function getApplicablePlugins(string $fieldType): iterable;

  /**
   * Returns a list of field types that can be handled by the enabled plugins.
   *
   * @return list<non-empty-string>
   *   Field types.
   */
  public function getApplicableFieldTypes(): array;

}
