<?php

declare(strict_types=1);

namespace Drupal\track_usage;

use Drupal\Core\Entity\EntityInterface;
use Drupal\track_usage\Entity\TrackConfigInterface;
use Drupal\track_usage\Model\Operation;

/**
 * Interface for `track_usage.recorder` service.
 */
interface RecorderInterface extends ReaderInterface {

  /**
   * Table for usage storage.
   */
  public const TABLE = 'track_usage';

  /**
   * Table for paths storage.
   */
  public const TABLE_PATHS = 'track_usage_paths';

  /**
   * Records target entity usages of an entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity for which to register target usages.
   * @param \Drupal\track_usage\Entity\TrackConfigInterface $config
   *   The track configuration.
   */
  public function record(EntityInterface $entity, TrackConfigInterface $config): void;

  /**
   * Cleans up the usage records.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity for which to register target usages.
   * @param \Drupal\track_usage\Model\Operation $operation
   *   The operation.
   */
  public function cleanup(EntityInterface $entity, Operation $operation): void;

}
