<?php

declare(strict_types=1);

namespace Drupal\track_usage;

use Drupal\Core\Entity\EntityInterface;
use Drupal\track_usage\Entity\TrackConfigInterface;
use Drupal\track_usage\Model\UsageCollection;

/**
 * Interface for `track_usage.tracker` service.
 */
interface TrackerInterface {

  /**
   * Records usages of target entity types by a given entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The source entity.
   * @param \Drupal\track_usage\Entity\TrackConfigInterface $config
   *   The track configuration.
   *
   * @return \Drupal\track_usage\Model\UsageCollection
   *   A list of usages.
   */
  public function track(EntityInterface $entity, TrackConfigInterface $config): UsageCollection;

}
