<?php

namespace Drupal\transform_api_views\EventSubscriber;

use Drupal\search_api\Event\IsRenderedInCurrentRequestEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Event subscriber for Transform API Views.
 */
final class TransformApiViewsSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a TransformApiViewsSubscriber object.
   */
  public function __construct(
    private readonly RequestStack $requestStack,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      'search_api.is_rendered_in_current_request' => ['isRenderedInCurrentRequest'],
    ];
  }

  /**
   * Event handler for the IS_RENDERED_IN_CURRENT_REQUEST event.
   */
  public function isRenderedInCurrentRequest(IsRenderedInCurrentRequestEvent $event): void {
    $request = $this->requestStack->getCurrentRequest();

    $route = $request->attributes->get('_route');

    // Mark view as rendered for Search API when results route is being rendered.
    if ($route === 'transform_api_views.view_results') {
      if (str_starts_with($event->getDisplay()->getBaseId(), 'views_')) {
        $event->setRendered(TRUE);
      }
    }
  }

}
