<?php

namespace Drupal\transform_api_views\Plugin\Transform\SectionComponent;

use Drupal\layout_builder\SectionComponent;
use Drupal\transform_api\Repository\EntityTransformRepositoryInterface;
use Drupal\transform_api\SectionComponentTransformBase;
use Drupal\transform_api_views\Transform\ViewTransform;

/**
 * Section component plugin for views blocks.
 *
 * @SectionComponentTransform(
 *  id = "views_block",
 *  title = "Views Block"
 * )
 */
class ViewsBlock extends SectionComponentTransformBase {

  /**
   * {@inheritdoc}
   */
  public function transform(SectionComponent $component, $transform_mode = EntityTransformRepositoryInterface::DEFAULT_DISPLAY_MODE) {
    /** @var \Drupal\views\ViewExecutable $view */
    $view = $component->getPlugin()->getViewExecutable();

    $configuration = $component->get('configuration');

    $configuration['items_per_page'] = $configuration['items_per_page'] ?? 'none';

    return new ViewTransform($view->id(), $view->current_display, $configuration);
  }

}
