<?php

namespace Drupal\transform_api\Transform;

use Drupal\Core\Cache\RefinableCacheableDependencyTrait;

/**
 *
 */
abstract class RefinableTransform extends TransformBase {

  use RefinableCacheableDependencyTrait;

  /**
   * The transformation array.
   *
   * @var array
   */
  protected array $transformation = [];

  /**
   * The transformation weight.
   *
   * @var int|null
   */
  protected $weight = NULL;

  /**
   * Gets the transformation array.
   *
   * @return array
   *   The transformation array.
   */
  public function getTransformation(): array {
    return $this->transformation;
  }

  /**
   * Set the transformation array to output.
   *
   * @param array $transformation
   *   The transformation array to output.
   */
  public function setTransformation(array $transformation) {
    $this->transformation = $transformation;
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight() {
    return $this->weight;
  }

  /**
   * Set the transformation weight.
   *
   * @param int|null $weight
   *   The transformation weight or NULL for no weight.
   */
  public function setWeight($weight) {
    $this->weight = $weight;
  }

  /**
   * {@inheritdoc}
   */
  public function transform() {
    $this->applyTo($this->transformation);
    return $this->transformation;
  }

}
