<?php

namespace Drupal\transform_api_views\EventSubscriber;

use Drupal\transform_api\Event\TransformMainContentEvent;
use Drupal\transform_api\TransformEvents;
use Drupal\transform_api_views\Transform\ViewTransform;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Handles canonical content entity urls as entity transforms.
 */
class ViewsMainContentSubscriber implements EventSubscriberInterface {

  /**
   * Handle entity routes as entity transforms.
   *
   * @param \Drupal\transform_api\Event\TransformMainContentEvent $event
   *   The Event to process.
   */
  public function onMainContent(TransformMainContentEvent $event) {
    $match = $event->getRouteMatch();
    if ($match->getRouteObject()->getDefaults()['_controller'] == 'Drupal\views\Routing\ViewPageController::handle' && !empty($match->getParameter('view_id')) && !empty($match->getParameter('display_id'))) {
      $view_id = $match->getParameter('view_id');
      $display_id = $match->getParameter('display_id');
      $args = [];
      /** @var \Symfony\Component\Routing\Route $route */
      $route = $match->getRouteObject();
      $map = $route->hasOption('_view_argument_map') ? $route->getOption('_view_argument_map') : [];
      /** @var \Symfony\Component\HttpFoundation\InputBag $parameters */
      $parameters = $match->getRawParameters();

      foreach ($map as $attribute => $parameter_name) {
        // Allow parameters be pulled from the request.
        // The map stores the actual name of the parameter in the request. Views
        // which override existing controller, use for example 'node' instead of
        // arg_nid as name.
        if (isset($map[$attribute])) {
          $attribute = $map[$attribute];
        }
        if ($arg = $parameters->get($attribute)) {
        }
        else {
          $arg = $match[$attribute];
        }

        if (isset($arg)) {
          $args[] = $arg;
        }
      }
      $event->setTransform(new ViewTransform($view_id, $display_id, [], $args));
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[TransformEvents::MAIN_CONTENT][] = ['onMainContent'];
    return $events;
  }

}
