<?php

namespace Drupal\transform_api\Configs;

use Drupal\Core\Entity\Display\EntityDisplayInterface;
use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Interface for transform modes.
 */
interface EntityTransformDisplayInterface extends EntityDisplayInterface {

  /**
   * Builds a transform array for the components of an entity.
   *
   * See the buildMultiple() method for details.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $entity
   *   The entity being displayed.
   *
   * @return array
   *   A transform array for the entity.
   *
   * @see \Drupal\transform_api\Configs\EntityTransformDisplayInterface::buildMultiple()
   */
  public function build(FieldableEntityInterface $entity);

  /**
   * Builds a transform array for the components of a set of entities.
   *
   * This only includes the components handled by the Display object, but
   * excludes 'extra fields', that are typically transformed through specific,
   * ad-hoc code in EntityTransformBuilderInterface::buildComponents() or in
   * hook_entity_transform() implementations.
   *
   * hook_entity_transform_build_alter() is invoked on each entity, allowing 3rd
   * party code to alter the transform array.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface[] $entities
   *   The entities being transformed.
   *
   * @return array
   *   A transform array for the entities, indexed by the same keys as the
   *   $entities array parameter.
   *
   * @see hook_entity_transform_build_alter()
   */
  public function buildMultiple(array $entities);

}
